﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// Settings panel for HTML export.
    /// </summary>
    public partial class HTMLSettingsControl : FormatSettingsControl
    {
        private const string FormatKey = "htm";
        private const string PropLayout = "layout";
        private const string PropMultiplePages = "multiplePages";
        private const string PropHeaderFooter = "concatHF";

        /// <summary>
        /// Creates the control.
        /// </summary>
        public HTMLSettingsControl()
        {
            InitializeComponent();
        }

        /// <inheritdoc />
        public override Bitmap Icon { get { return FormatResource.html_48; } }

        /// <inheritdoc />
        public override string Label { get { return "HTML"; } }

        /// <inheritdoc />
        public override string FileSuffix { get { return "html"; } }

        /// <inheritdoc />
        public override void CollectExportParameters(Dictionary<string, string> exportParams)
        {
            exportParams[URLRenderData.ParameterExportFmt] = FormatKey;
            if (rdbMultiple.Checked)
            {
                exportParams[PropMultiplePages] = URLRenderData.ValueTrue;
            }
            else
            {
                if (chbHeaderFooter.Checked)
                {
                    exportParams[PropLayout] = "concat";
                    exportParams[PropHeaderFooter] = URLRenderData.ValueTrue;
                }
                else
                {
                    exportParams[PropLayout] = "single";
                    exportParams[PropHeaderFooter] = URLRenderData.ValueFalse;
                }
            }
        }

        /// <summary>
        /// Handles the CheckedChanged event of the radio button.
        /// </summary>
        /// <param name="sender">the source of the event</param>
        /// <param name="e">the event arguments</param>
        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            chbHeaderFooter.Enabled = !rdbMultiple.Checked;
        }

        /// <summary>
        /// <inherticdoc/>
        /// </summary>
        override public HashSet<string> AllowedFormats
        {
            set
            {
                Allowed = value.Count == 0 || value.Contains("htm");
            }
        }
    }
}
